<?php
/*
 * =================================================
 * 		pageNumbers - Simple pagination class
 * =================================================
 * 
 * Files: pageNumbers.class.php
 * 
 * Version:			1.0
 * Created:			06-Feb-2008
 * Last modified:	06-Fev-2008
 * 
 * Author:			Cristian Radulescu
 * E-mail:			cr@cristian-radulescu.ro
 * Website:			http://cristian-radulescu.ro
 * 
 * License: Fell free to use and modify
 * 
 * Description: This class is used to create page 
 * numbers for multiple pages. The numbers are
 * returned as an array.
 * =================================================
 * 
 * Usage example: copy/paste the following code and 
 * save it as "index.php"
 * 
 * =========start index.php =========
<?php 
	//generate array
	$myResults = range(0, 710);

	$resultsPerPage = 20; //20 results on a page
	$totalPages = ceil(count($myResults)/$resultsPerPage); //calculate total number of pages
	echo "total pages = " . $totalPages . "<br />";

	$page = $_GET['p']; //get page number
	echo "page number = " . $page . "<br /><br />";

	//display results
	$sliceStart = ($page-1)*$resultsPerPage;
	$slice = $resultsPerPage;
	echo "<pre>";
	print_r(array_slice($myResults, $sliceStart, $slice));
	echo "</pre>";
	
	
	include("pageNumbers.class.php");
	
	//parameters: 
	//$page = current page number
	//$totalPages = total number of pages
	//3 = numbers to display on the left and right of the current page number
	$pag = new pageNumbers($page, $totalPages, 3); 

	//the first and the last page number will always be displayed
	//we need a separator between the first/last page number and the middle page numbers
	$separator = "...";
	foreach($pag->numbers as $pageNumber=>$type)
	{
		//each number has a type
		//there are 4 types: 
		//  "current" - the curent page number;
		//  "link" - link to other page numbers
		//  "separatorAfter" - first line number when it needs the separator (separator after number)
		//  "separatorBefore" - last line number when it needs the separator (separator before number)
		switch($type)
		{
			case "current": echo '&nbsp;' . $pageNumber . '&nbsp';
				break;
				
			case "link": echo '&nbsp<a href="index.php?p=' . $pageNumber . '">' . $pageNumber . '</a>&nbsp;';
				break;
				
			case "separatorAfter": echo '&nbsp<a href="index.php?p=' . $pageNumber . '">' . $pageNumber . '</a>&nbsp;' . $separator . '&nbsp;';
				break;
				
			case "separatorBefore": echo '&nbsp;' . $separator . '&nbsp;<a href="index.php?p=' . $pageNumber . '">' . $pageNumber . '</a>';
				break;
		}
	}
?>
 * =========end index.php =========
 */

class pageNumbers
{
	var $error = false;
	var $numbers = array();
	
	function pageNumbers($currentPage, $totalPages, $extraPages)
	{
		$this->checkForErrors($currentPage, $totalPages);
		if($this->error == true)
		{
			echo "error!\r\n"; exit();	
		}
		
		if(($currentPage <= ($extraPages+1)) && ($totalPages <= ($extraPages+1)))
		{
			for($i=1; $i<=$totalPages; $i++)
			{
				if($currentPage == $i)
				{
					$this->numbers[$i] = "current";
				} else
				{
					$this->numbers[$i] = "link";
				}
			}	
		} elseif(($currentPage <= ($extraPages+1)) && ($totalPages > ($extraPages+1)) && ($totalPages <= ($extraPages*2+1)))
		{
			for($i=1; $i<=$totalPages; $i++)
			{
				if($currentPage == $i)
				{
					$this->numbers[$i] = "current";
				} else
				{
					$this->numbers[$i] = "link";
				}
			}
		} elseif(($currentPage <= ($extraPages+1)) && ($totalPages > ($extraPages*2+1)))
		{
			for($i=1; $i<=($extraPages*2+1); $i++)
			{
				if($currentPage == $i)
				{
					$this->numbers[$i] = "current";
				} else
				{
					$this->numbers[$i] = "link";
				}
			}
			$this->numbers[$totalPages] = "separatorBefore";
		} elseif(($currentPage > ($extraPages+1)) && ($totalPages <= ($extraPages*2+1)))
		{
			for($i=1; $i<=$totalPages; $i++)
			{
				if($currentPage == $i)
				{
					$this->numbers[$i] = "current";
				} else
				{
					$this->numbers[$i] = "link";
				}
			}	
		} elseif(($currentPage > ($extraPages+1)) && ($totalPages > ($extraPages*2+1)))
		{
			$useSeparatorAfter = true;
			$useSeparatorBefore = true;
			
			if($currentPage == ($extraPages+2))
			{
				$startWith = 1;
				$useSeparatorAfter = false;
			} else 
			{
				$startWith = $currentPage-$extraPages;
				//$useSeparatorAfter = true;
			}
			
			if($currentPage < ($totalPages-$extraPages))
			{
				if($currentPage == ($totalPages-($extraPages+1)))
				{
					$endWith = $currentPage+($extraPages+1);
					$useSeparatorBefore = false;
				} else 
				{
					$endWith = $currentPage+$extraPages;
				}
			} else
			{
				$endWith = $totalPages;
				$startWith = ($totalPages-($extraPages*2));
				$useSeparatorBefore = false;
			}
			
			if($useSeparatorAfter)
			{
				$this->numbers[1] = "separatorAfter";
			}
	
			for($i=$startWith; $i<=$endWith; $i++)
			{
				if($currentPage == $i)
				{
					$this->numbers[$i] = "current";
				} else
				{
					$this->numbers[$i] = "link";
				}
			}
			
			if($useSeparatorBefore)
			{	
				$this->numbers[$totalPages] = "separatorBefore";
			}
		}
	}
	
	function checkForErrors($page, $totalPages)
	{
		if($page > $totalPages)
		{
			$this->error = true;
		}
		
		return $this->error;
	}
}

?>
